/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.builder.AbstractLootModifierBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;

public class ReplaceItemLootModifier
extends LootModifier {
    private final Ingredient original;
    private final ItemOutput replacement;
    private final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected ReplaceItemLootModifier(LootItemCondition[] conditionsIn, Ingredient original, ItemOutput replacement, LootItemFunction[] functions) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])functions);
    }

    public static Builder builder(Ingredient original, ItemOutput replacement) {
        return new Builder(original, replacement);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot.stream().map(stack -> {
            if (this.original.test(stack)) {
                ItemStack replacement = this.replacement.get();
                return this.combinedFunctions.apply(ItemHandlerHelper.copyStackWithSize((ItemStack)replacement, (int)(replacement.m_41613_() * stack.m_41613_())), context);
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final Ingredient input;
        private final ItemOutput replacement;
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();

        public Builder addFunction(LootItemFunction function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public void build(String name, GlobalLootModifierProvider provider) {
            provider.add(name, (GlobalLootModifierSerializer)MantleLoot.REPLACE_ITEM, (IGlobalLootModifier)new ReplaceItemLootModifier(this.getConditions(), this.input, this.replacement, this.functions.toArray(new LootItemFunction[0])));
        }

        private Builder(Ingredient input, ItemOutput replacement) {
            this.input = input;
            this.replacement = replacement;
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceItemLootModifier> {
        public ReplaceItemLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            JsonElement element = JsonHelper.getElement(object, "original");
            Ingredient original = element.isJsonPrimitive() ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RecipeHelper.deserializeItem(element.getAsString(), "original", Item.class)}) : Ingredient.m_43917_((JsonElement)element);
            ItemOutput replacement = ItemOutput.fromJson(JsonHelper.getElement(object, "replacement"));
            LootItemFunction[] functions = object.has("functions") ? (LootItemFunction[])AddEntryLootModifier.GSON.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"functions"), LootItemFunction[].class) : new LootItemFunction[]{};
            return new ReplaceItemLootModifier(conditions, original, replacement, functions);
        }

        public JsonObject write(ReplaceItemLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.add("original", instance.original.m_43942_());
            object.add("replacement", instance.replacement.serialize());
            if (instance.functions.length > 0) {
                object.add("functions", AddEntryLootModifier.GSON.toJsonTree((Object)instance.functions, LootItemFunction[].class));
            }
            return object;
        }
    }
}

